/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.peerid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.araymond.joal.core.client.emulated.generator.peerid.PeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.generation.PeerIdAlgorithm;
import org.araymond.joal.core.torrent.torrent.InfoHash;

public class TorrentVolatileRefreshPeerIdGenerator
extends PeerIdGenerator {
    private final Map<InfoHash, String> peerIdPerTorrent = new ConcurrentHashMap();

    @JsonCreator
    TorrentVolatileRefreshPeerIdGenerator(@JsonProperty(value="algorithm", required=true) PeerIdAlgorithm algorithm, @JsonProperty(value="shouldUrlEncode", required=true) boolean isUrlEncoded) {
        super(algorithm, isUrlEncoded);
    }

    public String getPeerId(InfoHash infoHash, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        this.peerIdPerTorrent.computeIfAbsent(infoHash, k -> super.generatePeerId());
        String peerId = (String)this.peerIdPerTorrent.get(infoHash);
        if (event == TrackerMessage.AnnounceRequestMessage.RequestEvent.STOPPED) {
            this.peerIdPerTorrent.remove(infoHash);
        }
        return peerId;
    }
}

