/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator.peerid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.araymond.joal.core.client.emulated.generator.peerid.PeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.TorrentPersistentRefreshPeerIdGenerator;
import org.araymond.joal.core.client.emulated.generator.peerid.generation.PeerIdAlgorithm;
import org.araymond.joal.core.torrent.torrent.InfoHash;

public class TorrentPersistentRefreshPeerIdGenerator
extends PeerIdGenerator {
    private final Map<InfoHash, AccessAwarePeerId> peerIdPerTorrent = new ConcurrentHashMap();
    private int getCounter = 0;

    @JsonCreator
    TorrentPersistentRefreshPeerIdGenerator(@JsonProperty(value="algorithm", required=true) PeerIdAlgorithm algorithm, @JsonProperty(value="shouldUrlEncode", required=true) boolean isUrlEncoded) {
        super(algorithm, isUrlEncoded);
    }

    public String getPeerId(InfoHash infoHash, TrackerMessage.AnnounceRequestMessage.RequestEvent event) {
        if (!this.peerIdPerTorrent.containsKey(infoHash)) {
            this.peerIdPerTorrent.put(infoHash, new AccessAwarePeerId(super.generatePeerId()));
        }
        String key = ((AccessAwarePeerId)this.peerIdPerTorrent.get(infoHash)).getPeerId();
        ++this.getCounter;
        if (this.getCounter >= 30) {
            this.getCounter = 0;
            this.evictOldEntries();
        }
        return key;
    }

    @VisibleForTesting
    void evictOldEntries() {
        new HashSet(this.peerIdPerTorrent.entrySet()).stream().filter(arg_0 -> this.shouldEvictEntry(arg_0)).forEach(entry -> this.peerIdPerTorrent.remove(entry.getKey()));
    }

    @VisibleForTesting
    boolean shouldEvictEntry(Map.Entry<InfoHash, AccessAwarePeerId> entry) {
        return ChronoUnit.MINUTES.between(entry.getValue().getLastAccess(), LocalDateTime.now()) >= 120L;
    }
}

