/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal.core.client.emulated.generator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.regex.Pattern;
import org.araymond.joal.core.client.emulated.utils.Casing;

public class UrlEncoder {
    private final String encodingExclusionPattern;
    private final Casing encodedHexCase;
    @JsonIgnore
    private final Pattern pattern;

    @JsonCreator
    public UrlEncoder(@JsonProperty(value="encodingExclusionPattern", required=true) String encodingExclusionPattern, @JsonProperty(value="encodedHexCase", required=true) Casing encodedHexCase) {
        this.encodingExclusionPattern = encodingExclusionPattern;
        this.encodedHexCase = encodedHexCase;
        this.pattern = Pattern.compile(this.encodingExclusionPattern);
    }

    public String encode(String toBeEncoded) {
        StringBuilder sb = new StringBuilder();
        for (char ch : toBeEncoded.toCharArray()) {
            sb.append(this.urlEncodeChar(ch));
        }
        return sb.toString();
    }

    @VisibleForTesting
    String urlEncodeChar(char character) {
        if (this.pattern.matcher(String.valueOf(character)).matches()) {
            return String.valueOf(character);
        }
        String hex = character == '\u0000' ? "%00" : String.format("%%%02x", character);
        return this.encodedHexCase.toCase(hex);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UrlEncoder)) {
            return false;
        }
        UrlEncoder other = (UrlEncoder)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$encodingExclusionPattern = this.getEncodingExclusionPattern();
        String other$encodingExclusionPattern = other.getEncodingExclusionPattern();
        if (this$encodingExclusionPattern == null ? other$encodingExclusionPattern != null : !this$encodingExclusionPattern.equals(other$encodingExclusionPattern)) {
            return false;
        }
        Casing this$encodedHexCase = this.getEncodedHexCase();
        Casing other$encodedHexCase = other.getEncodedHexCase();
        return !(this$encodedHexCase == null ? other$encodedHexCase != null : !this$encodedHexCase.equals(other$encodedHexCase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UrlEncoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encodingExclusionPattern = this.getEncodingExclusionPattern();
        result = result * 59 + ($encodingExclusionPattern == null ? 43 : $encodingExclusionPattern.hashCode());
        Casing $encodedHexCase = this.getEncodedHexCase();
        result = result * 59 + ($encodedHexCase == null ? 43 : $encodedHexCase.hashCode());
        return result;
    }

    public String getEncodingExclusionPattern() {
        return this.encodingExclusionPattern;
    }

    public Casing getEncodedHexCase() {
        return this.encodedHexCase;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

