/*
 * Decompiled with CFR 0.152.
 */
package org.araymond.joal;

import javax.inject.Inject;
import org.araymond.joal.core.SeedManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"!test"})
@Component
public class ApplicationReadyListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(ApplicationReadyListener.class);
    private final SeedManager manager;
    private final ConfigurableApplicationContext applicationContext;

    @Inject
    public ApplicationReadyListener(SeedManager manager, ConfigurableApplicationContext applicationContext) {
        this.manager = manager;
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            this.manager.init();
            this.manager.startSeeding();
        }
        catch (Throwable e) {
            IllegalStateException wrapped = new IllegalStateException("Fatal error encountered", e);
            log.error("Fatal error encountered", (Throwable)wrapped);
            this.applicationContext.close();
        }
    }
}

