#!/bin/bash

get_active_profile() {
  asusctl profile get 2>/dev/null | awk -F': ' '/^Active profile:/ {print $2; exit}'
}

CURRENT="$(get_active_profile)"

case "$CURRENT" in
  Quiet)       asusctl profile set Balanced ;;
  Balanced)    asusctl profile set Performance ;;
  Performance) asusctl profile set Quiet ;;
  *)           asusctl profile set Balanced ;;
esac

NEW="$(get_active_profile)"

notify-send \
  -a "ASUS Profile" \
  -u low \
  "Mode ASUS changé" \
  "Profil actif : $NEW"

