/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.quicksort;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.pcal.quicksort.QuicksortConfig;
import net.pcal.quicksort.QuicksortConfigParser;
import net.pcal.quicksort.QuicksortService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class QuicksortInitializer
implements ModInitializer {
    private static final String DEFAULT_CONFIG_RESOURCE_NAME = "quicksort-default-config.json5";
    private static final String CONFIG_FILENAME = "quicksort.json5";

    public void onInitialize() {
        try {
            this.initialize();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void initialize() throws IOException {
        QuicksortConfig config;
        QuicksortConfig defaultConfig;
        Logger logger = LogManager.getLogger((String)"Quicksort");
        Path configDirPath = Paths.get("config", new String[0]);
        Path configFilePath = Paths.get("config", CONFIG_FILENAME);
        if (!configFilePath.toFile().exists()) {
            logger.info("[Quicksort] Writing default configuration to " + String.valueOf(configFilePath));
            try (InputStream in = QuicksortInitializer.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG_RESOURCE_NAME);){
                if (in == null) {
                    throw new IllegalStateException("Unable to load quicksort-default-config.json5");
                }
                Files.createDirectories(configDirPath, new FileAttribute[0]);
                Files.copy(in, configFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        try (InputStream in = QuicksortInitializer.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG_RESOURCE_NAME);){
            defaultConfig = QuicksortConfigParser.parse(in, null);
        }
        logger.info("[Quicksort] Loading configuration from " + String.valueOf(configFilePath));
        in = new FileInputStream(configFilePath.toFile());
        try {
            config = QuicksortConfigParser.parse(in, defaultConfig.chestConfigs().get(0));
        }
        finally {
            in.close();
        }
        if (config.logLevel() != Level.INFO) {
            Configurator.setLevel((String)"Quicksort", (Level)config.logLevel());
            logger.info("[Quicksort] LogLevel set to " + String.valueOf(config.logLevel()));
        }
        QuicksortService.getInstance().init(config, logger);
        ServerTickEvents.END_WORLD_TICK.register((Object)QuicksortService.getInstance());
        logger.info("[Quicksort] Initialized");
    }
}

