/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.utli;

import com.soradgaming.simplehudenhanced.SimpleHudEnhanced;
import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.hud.EquipmentInfoStack;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3545;

public class TrinketAccessor {
    private final class_1657 player;
    private List<EquipmentInfoStack> equipmentInfo;
    private final SimpleHudEnhancedConfig config;

    public TrinketAccessor(class_1657 player, SimpleHudEnhancedConfig config) {
        this.player = player;
        this.config = config;
        this.setEquipmentInfo();
    }

    public List<EquipmentInfoStack> getEquipmentInfo() {
        return this.equipmentInfo;
    }

    public void setEquipmentInfo() {
        if (SimpleHudEnhanced.isTrinketsInstalled()) {
            Optional trinketComponentOptional = TrinketsApi.getTrinketComponent((class_1309)this.player);
            if (trinketComponentOptional.isPresent()) {
                TrinketComponent trinketComponent = (TrinketComponent)trinketComponentOptional.get();
                List trinketData = trinketComponent.getAllEquipped();
                this.equipmentInfo = new ArrayList<EquipmentInfoStack>();
                if (this.config.equipmentStatus.slots.Head) {
                    this.addTrinketData(trinketData, "head");
                }
                if (this.config.equipmentStatus.slots.Body) {
                    this.addTrinketData(trinketData, "chest");
                }
                if (this.config.equipmentStatus.slots.Legs) {
                    this.addTrinketData(trinketData, "legs");
                }
                if (this.config.equipmentStatus.slots.Boots) {
                    this.addTrinketData(trinketData, "feet");
                }
                if (this.config.equipmentStatus.slots.MainHand) {
                    this.addTrinketData(trinketData, "hand");
                }
                if (this.config.equipmentStatus.slots.OffHand) {
                    this.addTrinketData(trinketData, "offhand");
                }
            }
        } else {
            this.equipmentInfo = new ArrayList<EquipmentInfoStack>(Arrays.asList(new EquipmentInfoStack(this.player.method_31548().method_5438(39)), new EquipmentInfoStack(this.player.method_31548().method_5438(38)), new EquipmentInfoStack(this.player.method_31548().method_5438(37)), new EquipmentInfoStack(this.player.method_31548().method_5438(36)), new EquipmentInfoStack(this.player.method_6079()), new EquipmentInfoStack(this.player.method_6047())));
        }
    }

    private void addTrinketData(List<class_3545<SlotReference, class_1799>> trinketData, String selectedGroup) {
        if (trinketData.isEmpty()) {
            class_1799 defaultItem = this.getDefaultItemForSlot(selectedGroup);
            if (defaultItem != null) {
                this.equipmentInfo.add(new EquipmentInfoStack(defaultItem));
            }
            return;
        }
        int x = 0;
        for (class_3545<SlotReference, class_1799> trinketPair : trinketData) {
            String group = ((SlotReference)trinketPair.method_15442()).inventory().getSlotType().getGroup();
            if (x == 0) {
                class_1799 defaultItem = this.getDefaultItemForSlot(selectedGroup);
                if (defaultItem != null) {
                    this.equipmentInfo.add(new EquipmentInfoStack(defaultItem));
                }
                ++x;
            }
            if (!group.equals(selectedGroup)) continue;
            this.equipmentInfo.add(new EquipmentInfoStack((class_1799)trinketPair.method_15441()));
        }
    }

    private class_1799 getDefaultItemForSlot(String group) {
        return switch (group) {
            case "head" -> this.player.method_31548().method_5438(39);
            case "chest" -> this.player.method_31548().method_5438(38);
            case "legs" -> this.player.method_31548().method_5438(37);
            case "feet" -> this.player.method_31548().method_5438(36);
            case "hand" -> this.player.method_6047();
            case "offhand" -> this.player.method_6079();
            default -> null;
        };
    }
}

