/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.hud;

import com.soradgaming.simplehudenhanced.cache.MovementCache;
import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.hud.GameInfo;
import com.soradgaming.simplehudenhanced.hud.ScreenManager;
import com.soradgaming.simplehudenhanced.utli.Utilities;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class Movement {
    private final class_310 client = class_310.method_1551();
    private final class_327 renderer;
    private final SimpleHudEnhancedConfig config;
    private final class_332 context;
    private final MovementCache movementCache;

    public Movement(class_332 context, SimpleHudEnhancedConfig config, MovementCache movementCache) {
        this.renderer = this.client.field_1772;
        this.config = config;
        this.context = context;
        this.movementCache = movementCache;
    }

    public void init(GameInfo GameInformation) {
        if (this.config.movementStatus.movementTypes.toggleSwimmingStatus && GameInformation.isPlayerSwimming()) {
            this.draw(this.context, "text.hud.simplehudenhanced.swimming");
        } else if (this.config.movementStatus.movementTypes.toggleFlyingStatus && GameInformation.isPlayerFlying()) {
            this.draw(this.context, "text.hud.simplehudenhanced.flying");
        } else if (this.config.movementStatus.movementTypes.toggleSneakStatus && GameInformation.isPlayerSneaking()) {
            this.draw(this.context, "text.hud.simplehudenhanced.sneaking");
        } else if (this.config.movementStatus.movementTypes.toggleSprintStatus && GameInformation.isPlayerSprinting()) {
            this.draw(this.context, "text.hud.simplehudenhanced.sprinting");
        }
    }

    private void draw(class_332 context, String textKey) {
        String text = Utilities.translatable(textKey).getString();
        float Scale = (float)this.config.movementStatus.textScale / 100.0f;
        ScreenManager screenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        screenManager.setPadding(4);
        int xAxis = screenManager.calculateXAxis(this.config.movementStatus.movementStatusLocationX, Scale, this.renderer.method_1727(text));
        Objects.requireNonNull(this.renderer);
        int yAxis = screenManager.calculateYAxis(9, 1, this.config.movementStatus.movementStatusLocationY, Scale);
        screenManager.setScale(context, Scale);
        context.method_25303(this.renderer, text, xAxis, yAxis, Utilities.addAlpha(this.config.uiConfig.textColor));
        screenManager.resetScale(context);
    }

    public void drawPaperDoll(class_332 context) {
        if (!this.config.paperDoll.togglePaperDoll) {
            return;
        }
        class_746 entity = this.client.field_1724;
        if (entity == null) {
            return;
        }
        ScreenManager screenManager = new ScreenManager(this.client.method_22683().method_4486(), this.client.method_22683().method_4502());
        float scale = (float)this.config.paperDoll.textScale / 100.0f;
        float size = 20.0f * scale;
        screenManager.setPadding((int)(26.0f * scale));
        int xAxis = screenManager.calculateXAxis(this.config.paperDoll.paperDollLocationX, 1.0, 0);
        screenManager.setPadding((int)(26.0f * scale));
        int yAxis = screenManager.calculateYAxis(0, 1, this.config.paperDoll.paperDollLocationY, 1.0);
        int x1 = Math.round((float)xAxis - 60.0f * scale);
        int y1 = Math.round((float)yAxis - 60.0f * scale);
        int x2 = Math.round((float)xAxis + 60.0f * scale);
        int y2 = Math.round((float)yAxis + 60.0f * scale);
        this.drawEntityInternal(context, x1, y1, x2, y2, size, (class_1309)entity);
    }

    private void drawEntityInternal(class_332 context, int x1, int y1, int x2, int y2, float size, class_1309 entity) {
        context.method_44379(x1, y1, x2, y2);
        Quaternionf quaternionZ = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionX = new Quaternionf().rotateX(0.2617994f);
        quaternionZ.mul((Quaternionfc)quaternionX);
        float originalPitch = entity.method_36455();
        float originalBodyYaw = entity.field_6283;
        float originalHeadYaw = entity.field_6241;
        float originalPrevPitch = entity.field_6004;
        float originalPrevBodyYaw = entity.field_6220;
        float originalPrevHeadYaw = entity.field_6259;
        this.applyEntityRotations(entity);
        float yOffset = (entity.method_17682() + (1.0f - this.movementCache.getCurrentHeightOffset())) * 0.5f;
        Vector3f vector3f = new Vector3f(0.0f, yOffset, 0.0f);
        class_490.method_48472((class_332)context, (int)x1, (int)y1, (int)x2, (int)y2, (float)size, (Vector3f)vector3f, (Quaternionf)quaternionZ, (Quaternionf)quaternionX, (class_1309)entity);
        entity.method_36457(originalPitch);
        entity.field_6283 = originalBodyYaw;
        entity.field_6241 = originalHeadYaw;
        entity.field_6004 = originalPrevPitch;
        entity.field_6220 = originalPrevBodyYaw;
        entity.field_6259 = originalPrevHeadYaw;
        context.method_44380();
    }

    private void applyEntityRotations(class_1309 entity) {
        if (this.config.paperDoll.paperDollLocationY >= 50) {
            entity.method_36457(-7.5f);
            entity.field_6004 = -7.5f;
        } else {
            entity.method_36457(7.5f);
            entity.field_6004 = 7.5f;
        }
        float defaultRotationYaw = 180.0f;
        defaultRotationYaw = this.config.paperDoll.paperDollLocationX >= 50 ? (defaultRotationYaw += 20.0f) : (defaultRotationYaw -= 20.0f);
        float yRotOffset = 0.0f;
        float yRotOffsetO = 0.0f;
        entity.field_6283 = entity.field_6220 = defaultRotationYaw;
        entity.field_6259 = defaultRotationYaw + yRotOffsetO;
        entity.field_6241 = defaultRotationYaw + yRotOffset;
    }
}

