/*
 * Decompiled with CFR 0.152.
 */
package com.soradgaming.simplehudenhanced.cache;

import com.soradgaming.simplehudenhanced.config.EquipmentOrientation;
import com.soradgaming.simplehudenhanced.config.SimpleHudEnhancedConfig;
import com.soradgaming.simplehudenhanced.hud.EquipmentInfoStack;
import com.soradgaming.simplehudenhanced.hud.ScreenManager;
import com.soradgaming.simplehudenhanced.utli.TrinketAccessor;
import com.soradgaming.simplehudenhanced.utli.Utilities;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_746;

public class EquipmentCache {
    private static EquipmentCache instance;
    private List<EquipmentInfoStack> equipmentInfo;
    private int longestString = 0;
    private final SimpleHudEnhancedConfig config;
    private class_746 player;
    private boolean getLongestStringDeadlock;
    private int longestStringOLD;
    private boolean screenManagerDeadlock;
    private ScreenManager screenManagerOLD;
    private boolean getEquipmentInfoDeadlock;
    private List<EquipmentInfoStack> equipmentInfoOLD;
    private ScreenManager screenManager;

    private EquipmentCache(SimpleHudEnhancedConfig config) {
        this.config = config;
    }

    public static EquipmentCache getInstance(SimpleHudEnhancedConfig config) {
        if (instance == null) {
            instance = new EquipmentCache(config);
        }
        return instance;
    }

    public void updateCache(class_746 player) {
        this.createEquipment(player);
        this.calculateLongestString();
        this.calculateScreen();
    }

    public synchronized List<EquipmentInfoStack> getEquipmentInfo() {
        if (this.getEquipmentInfoDeadlock) {
            return this.equipmentInfoOLD;
        }
        return this.equipmentInfo;
    }

    private void createEquipment(class_746 player) {
        this.equipmentInfoOLD = this.equipmentInfo;
        this.getEquipmentInfoDeadlock = true;
        this.player = player;
        TrinketAccessor trinketData = new TrinketAccessor((class_1657)player, this.config);
        this.equipmentInfo = trinketData.getEquipmentInfo();
        this.equipmentInfo.removeIf(equipment -> equipment.getItem().method_7909().equals(class_2246.field_10124.method_8389()));
        this.equipmentInfo.removeIf(equipment -> equipment.getItem().method_7947() == 0);
        if (!this.config.equipmentStatus.showNonTools) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().method_7936() == 0);
        }
        if (this.config.equipmentStatus.Durability.showDurability) {
            this.getDurability();
        }
        if (!this.config.equipmentStatus.slots.Head) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_31548().method_5438(39)));
        }
        if (!this.config.equipmentStatus.slots.Body) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_31548().method_5438(38)));
        }
        if (!this.config.equipmentStatus.slots.Legs) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_31548().method_5438(37)));
        }
        if (!this.config.equipmentStatus.slots.Boots) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_31548().method_5438(36)));
        }
        if (!this.config.equipmentStatus.slots.OffHand) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_6079()));
        }
        if (!this.config.equipmentStatus.slots.MainHand) {
            this.equipmentInfo.removeIf(equipment -> equipment.getItem().equals(this.player.method_6047()));
        }
        this.getEquipmentInfoDeadlock = false;
    }

    private void getDurability() {
        for (EquipmentInfoStack index : this.equipmentInfo) {
            class_1799 item = index.getItem();
            if (this.isItemDurabilityDisabled(item)) {
                index.setText("");
                continue;
            }
            if (item.method_7936() != 0) {
                int currentDurability = item.method_7936() - item.method_7919();
                if (this.config.equipmentStatus.Durability.showDurabilityAsPercentage) {
                    index.setText(String.format("%s%%", currentDurability * 100 / item.method_7936()));
                } else if (this.config.equipmentStatus.Durability.showTotalCount) {
                    index.setText(String.format("%s/%s", currentDurability, item.method_7936()));
                } else {
                    index.setText(String.format("%s", currentDurability));
                }
                if (this.config.equipmentStatus.Durability.showColour && item.method_7919() != 0) {
                    index.setColor(item.method_31580());
                    continue;
                }
                index.setColor(Utilities.addAlpha(this.config.uiConfig.textColor));
                continue;
            }
            if (this.config.equipmentStatus.showCount && this.player.method_31548().method_18861(item.method_7909()) > 1) {
                if (this.player.method_31548().method_18861(item.method_7909()) == item.method_7947()) {
                    index.setText(String.valueOf(item.method_7947()));
                    continue;
                }
                index.setText(item.method_7947() + " (" + this.player.method_31548().method_18861(item.method_7909()) + ")");
                continue;
            }
            index.setText("");
        }
    }

    private boolean isItemDurabilityDisabled(class_1799 item) {
        if (item.equals(this.player.method_6047())) {
            return !this.config.equipmentStatus.Durability.slots.MainHand;
        }
        if (item.equals(this.player.method_6079())) {
            return !this.config.equipmentStatus.Durability.slots.OffHand;
        }
        if (item.equals(this.player.method_31548().method_5438(36))) {
            return !this.config.equipmentStatus.Durability.slots.Boots;
        }
        if (item.equals(this.player.method_31548().method_5438(37))) {
            return !this.config.equipmentStatus.Durability.slots.Legs;
        }
        if (item.equals(this.player.method_31548().method_5438(38))) {
            return !this.config.equipmentStatus.Durability.slots.Body;
        }
        if (item.equals(this.player.method_31548().method_5438(39))) {
            return !this.config.equipmentStatus.Durability.slots.Head;
        }
        return false;
    }

    public int getLongestString() {
        if (this.getLongestStringDeadlock) {
            return this.longestStringOLD;
        }
        return this.longestString;
    }

    private void calculateLongestString() {
        this.longestStringOLD = this.longestString;
        this.getLongestStringDeadlock = true;
        int longestString = 0;
        int BoxWidth = 0;
        for (EquipmentInfoStack index : this.equipmentInfo) {
            String s = index.getText();
            if (s.length() <= longestString) continue;
            longestString = s.length();
            BoxWidth = class_310.method_1551().field_1772.method_1727(s);
        }
        this.longestString = BoxWidth;
        this.getLongestStringDeadlock = false;
    }

    public synchronized ScreenManager getScreenManager() {
        if (this.screenManagerDeadlock) {
            return this.screenManagerOLD;
        }
        return this.screenManager;
    }

    private void calculateScreen() {
        this.screenManagerOLD = this.screenManager;
        this.screenManagerDeadlock = true;
        class_310 client = class_310.method_1551();
        class_327 renderer = client.field_1772;
        int configX = this.config.equipmentStatus.equipmentStatusLocationX;
        int configY = this.config.equipmentStatus.equipmentStatusLocationY;
        float Scale = (float)this.config.equipmentStatus.textScale / 100.0f;
        int lineHeight = 16;
        this.screenManager = new ScreenManager(client.method_22683().method_4486(), client.method_22683().method_4502());
        this.screenManager.setPadding(4);
        int xAxis = this.screenManager.calculateXAxis(configX, Scale, this.longestString + 16);
        int yAxis = this.screenManager.calculateYAxis(lineHeight, this.equipmentInfo.size(), configY, Scale);
        if (this.config.equipmentStatus.equipmentOrientation == EquipmentOrientation.Horizontal) {
            int total = 0;
            for (EquipmentInfoStack index : this.equipmentInfo) {
                int lineLength = renderer.method_1727(index.getText());
                total += lineLength;
            }
            xAxis = this.screenManager.calculateXAxis(configX, Scale, total + 24 * this.equipmentInfo.size() - 4);
            yAxis = this.screenManager.calculateYAxis(lineHeight, 1, configY, Scale);
        }
        this.screenManager.saveXAxis(xAxis);
        this.screenManager.saveYAxis(yAxis);
        this.screenManager.saveScale(Scale);
        this.screenManagerDeadlock = false;
    }
}

