/*
 * Decompiled with CFR 0.152.
 */
package de.greenman999.fullbright;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullbrightConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullbrightConfig.class);
    private static final String FILE_NAME = "fullbright.properties";
    private static volatile boolean toggled = false;
    private static volatile int strength = 10;
    private static final ExecutorService IO_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "fullbright-config-writer");
        t.setDaemon(true);
        return t;
    });

    public static synchronized void load() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create config directory {}", (Object)configDir, (Object)e);
        }
        Path path = configDir.resolve(FILE_NAME);
        Properties props = new Properties();
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                props.load(in);
                toggled = Boolean.parseBoolean(props.getProperty("toggled", "false"));
                try {
                    FullbrightConfig.setStrength(Integer.parseInt(props.getProperty("strength", "10")));
                }
                catch (NumberFormatException e) {
                    FullbrightConfig.setStrength(10);
                }
                LOGGER.info("Fullbright config loaded from {} (toggled={}, strength={})", new Object[]{path, toggled, strength});
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load Fullbright config from {}", (Object)path, (Object)e);
            }
        } else {
            FullbrightConfig.save();
        }
    }

    public static void saveAsync() {
        boolean snapshotToggled = toggled;
        int snapshotStrength = strength;
        IO_EXECUTOR.submit(() -> FullbrightConfig.saveToDisk(snapshotToggled, snapshotStrength));
    }

    private static void saveToDisk(boolean toggledSnapshot, int strengthSnapshot) {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to create config directory {}", (Object)configDir, (Object)e);
        }
        Path path = configDir.resolve(FILE_NAME);
        Properties props = new Properties();
        props.setProperty("toggled", Boolean.toString(toggledSnapshot));
        props.setProperty("strength", Integer.toString(strengthSnapshot));
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            props.store(out, "Fullbright config");
            LOGGER.info("Fullbright config saved to {}", (Object)path);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to save Fullbright config to {}", (Object)path, (Object)e);
        }
    }

    public static synchronized void save() {
        FullbrightConfig.saveToDisk(toggled, strength);
    }

    public static boolean isToggled() {
        return toggled;
    }

    public static int getStrength() {
        return strength;
    }

    public static synchronized void toggle() {
        toggled = !toggled;
        FullbrightConfig.saveAsync();
    }

    public static synchronized void setStrength(int value) {
        int clamped = Math.clamp((long)value, 0, 10);
        if (clamped != value) {
            LOGGER.warn("Attempted to set strength {} out of bounds; clamping to {}", (Object)value, (Object)clamped);
        }
        strength = clamped;
        FullbrightConfig.saveAsync();
    }

    public static void shutdownIoExecutor() {
        IO_EXECUTOR.shutdown();
    }
}

