/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.util.sorting;

import java.nio.ByteBuffer;
import net.caffeinemc.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.client.util.sorting.RadixSort;
import net.caffeinemc.mods.sodium.client.util.sorting.VertexSortingExtended;
import net.minecraft.class_11899;
import net.minecraft.class_8251;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class VertexSorters {
    public static VertexSortingExtended distance(float x, float y, float z) {
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return SortByDistanceToOrigin.INSTANCE;
        }
        return new SortByDistanceToPoint(x, y, z);
    }

    public static VertexSortingExtended orthographicZ() {
        return SortByOrthographicZ.INSTANCE;
    }

    public static VertexSortingExtended fallback(class_8251.class_8252 metric) {
        return new SortByFallback(metric);
    }

    public static int[] sort(ByteBuffer buffer, int vertexCount, int vertexStride, VertexSortingExtended sorting) {
        Validate.isTrue((buffer.remaining() >= vertexStride * vertexCount ? 1 : 0) != 0, (String)"Vertex buffer is not large enough to contain all vertices", (Object[])new Object[0]);
        long pVertex0 = MemoryUtil.memAddress((ByteBuffer)buffer);
        long pVertex2 = MemoryUtil.memAddress((ByteBuffer)buffer, (int)(vertexStride * 2));
        int primitiveCount = vertexCount / 4;
        int primitiveStride = vertexStride * 4;
        int[] keys = new int[primitiveCount];
        int[] perm = new int[primitiveCount];
        for (int primitiveId = 0; primitiveId < primitiveCount; ++primitiveId) {
            float v0x = MemoryUtil.memGetFloat((long)(pVertex0 + 0L));
            float v0y = MemoryUtil.memGetFloat((long)(pVertex0 + 4L));
            float v0z = MemoryUtil.memGetFloat((long)(pVertex0 + 8L));
            float v2x = MemoryUtil.memGetFloat((long)(pVertex2 + 0L));
            float v2y = MemoryUtil.memGetFloat((long)(pVertex2 + 4L));
            float v2z = MemoryUtil.memGetFloat((long)(pVertex2 + 8L));
            float cx = (v0x + v2x) * 0.5f;
            float cy = (v0y + v2y) * 0.5f;
            float cz = (v0z + v2z) * 0.5f;
            keys[primitiveId] = MathUtil.floatToComparableInt(-sorting.applyMetric(cx, cy, cz));
            perm[primitiveId] = primitiveId;
            pVertex0 += (long)primitiveStride;
            pVertex2 += (long)primitiveStride;
        }
        RadixSort.sortIndirect(perm, keys, true);
        return perm;
    }

    private static class SortByDistanceToOrigin
    extends AbstractSorter {
        private static final SortByDistanceToOrigin INSTANCE = new SortByDistanceToOrigin();

        private SortByDistanceToOrigin() {
        }

        @Override
        public float applyMetric(float x, float y, float z) {
            return x * x + y * y + z * z;
        }
    }

    private static class SortByDistanceToPoint
    extends AbstractSorter {
        private final float x;
        private final float y;
        private final float z;

        private SortByDistanceToPoint(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public float applyMetric(float x, float y, float z) {
            float dx = this.x - x;
            float dy = this.y - y;
            float dz = this.z - z;
            return dx * dx + dy * dy + dz * dz;
        }
    }

    private static class SortByOrthographicZ
    extends AbstractSorter {
        private static final SortByOrthographicZ INSTANCE = new SortByOrthographicZ();

        private SortByOrthographicZ() {
        }

        @Override
        public float applyMetric(float x, float y, float z) {
            return -z;
        }
    }

    private static class SortByFallback
    extends AbstractSorter {
        private final class_8251.class_8252 function;
        private final Vector3f scratch = new Vector3f();

        private SortByFallback(class_8251.class_8252 function) {
            this.function = function;
        }

        @Override
        public float applyMetric(float x, float y, float z) {
            return this.function.apply(this.scratch.set(x, y, z));
        }
    }

    private static abstract class AbstractSorter
    implements VertexSortingExtended {
        private AbstractSorter() {
        }

        public final int @NotNull [] sort(class_11899 centroids) {
            int length = centroids.method_74170();
            int[] keys = new int[length];
            int[] perm = new int[length];
            for (int index = 0; index < length; ++index) {
                keys[index] = ~MathUtil.floatToComparableInt(this.applyMetric(centroids.method_74171(index), centroids.method_74175(index), centroids.method_74176(index)));
                perm[index] = index;
            }
            RadixSort.sortIndirect(perm, keys, true);
            return perm;
        }
    }
}

